//Source file: H:\MIDDLEWARE\SRC\ALKINDI\BUSINESSSERVICES\UTIL\LOGMANAGER.JAVA

package Alkindi.Services.Util;

import javax.naming.*;
import javax.jms.*;
import java.text.DateFormat;
import java.util.Date;

/* 
$Header: LogManager.java, 15, 3/1/01 3:28:22 PM, Schwartz, Joe$
$Log: 
 15   Alkindi Development1.14        3/1/01 3:28:22 PM    Schwartz, Joe  
      Cleaned up debug output.
 14   Alkindi Development1.13        1/26/01 5:48:29 PM   Schwartz, Joe  
      Improving efficiency.
 13   Alkindi Development1.12        1/4/01 2:11:00 PM    Schwartz, Joe  
      Changed finalizer to free more resources.
 12   Alkindi Development1.11        1/2/01 3:05:19 PM    Schwartz, Joe  
      Removed unnecessary console logging.
 11   Alkindi Development1.10        12/28/00 1:07:26 PM  Schwartz, Joe   Added
      Version Control header info.
 10   Alkindi Development1.9         12/27/00 1:43:14 PM  Schwartz, Joe   
 9    Alkindi Development1.8         12/26/00 6:57:13 PM  Schwartz, Joe   
 8    Alkindi Development1.7         12/26/00 5:36:59 PM  Schwartz, Joe   
 7    Alkindi Development1.6         12/26/00 1:04:11 PM  Schwartz, Joe   
 6    Alkindi Development1.5         12/22/00 5:30:23 PM  Schwartz, Joe   
 5    Alkindi Development1.4         12/20/00 5:44:43 PM  Schwartz, Joe   
 4    Alkindi Development1.3         12/18/00 12:05:37 PM Schwartz, Joe   Moved
      internal data classes to Utils package & regenerated classes from Rose.
 3    Alkindi Development1.2         12/7/00 10:34:31 AM  Schwartz, Joe  
      Improved date/time formatting in logs.
 2    Alkindi Development1.1         11/14/00 12:53:13 PM Schwartz, Joe   
 1    Alkindi Development1.0         11/8/00 2:58:39 PM   Schwartz, Joe   
$
$NoKeywords$
 */

/**
 * Provides an interface to  logging facilities for the server objects. Posts logs to message queues using JMS.
 */
public class LogManager 
{
	
	/**
	 * Flag to control debug output.
	 */
	private boolean debug = false;
	
	/**
	 * The JMS Publisher object for errors.
	 */
	private TopicPublisher errPublisher = null;
	
	/**
	 * The JMS Topic object for errors.
	 */
	private Topic errTopic = null;
	
	/**
	 * The JMS Connection object.
	 */
	private TopicConnection jmsConn = null;
	
	/**
	 * The JMS Session object.
	 */
	private TopicSession jmsSession = null;
	
	/**
	 * The JMS Publisher object for logs.
	 */
	private TopicPublisher logPublisher = null;
	
	/**
	 * The JMS Topic object for logs.
	 */
	private Topic logTopic = null;
	
	protected void finalize() throws Throwable 
	{
		if (logPublisher != null) 
			logPublisher.close();
		if (errPublisher != null)
			errPublisher.close();
		if (jmsSession != null)
			jmsSession.close();
/*		try {
			if (jmsConn != null)
				jmsConn.close();
		}
		catch(Exception e) {
		}*/
		super.finalize();
	}
	
	/**
	 * Debug output for streams.
	 * @param className the name of the Class to use in logging
	 * @param methodName the name of the Method to use in logging
	 * @param msg the message to log
	 * @return void
	 * @roseuid 3A098F1F006D
	 */
	public final void dbgLog(final String className, final String methodName, final String message) 
	{
		if (debug) {
			log(className, methodName, message);
		}
	}
	
	/**
	 * Logs an error with a class name and a method name.
	 * @param className the name of the Class to use in logging
	 * @param methodName the name of the Method to use in logging
	 * @param msg the message to log
	 * @return void
	 * @roseuid 3A0960200280
	 */
	public final void err(final String className, final String methodName, final String msg) 
	{
		String formattedMsg = formatMsg(className, methodName, msg);
		try {
			TextMessage tMsg = jmsSession.createTextMessage();
			tMsg.setText(formattedMsg);
			errPublisher.publish(tMsg);
		}
		catch (Exception e) {
			System.out.println("LOG ERROR: " + e.getMessage());
			e.printStackTrace();
		}
	}
	
	/**
	 * Formats the text message for both output methods.
	 * @roseuid 3A09747F02CE
	 */
	private final java.lang.String formatMsg(final String className, final String methodName, final String msg) 
	{
		//String now = java.util.Calendar.getInstance().getTime().toString();
		Date now = java.util.Calendar.getInstance().getTime();
		StringBuffer msgBuf = new StringBuffer( DateFormat.getDateTimeInstance(DateFormat.SHORT, DateFormat.SHORT).format(now));
		msgBuf.append(' ');
		msgBuf.append(className);
		msgBuf.append('.');
		msgBuf.append(methodName);
		msgBuf.append(": ");
		msgBuf.append(msg);
		msgBuf.append('\n');
		return 	msgBuf.toString();
	}
	
	/**
	 * Logs a message with a class name and a method name.
	 * @param className the name of the Class to use in logging
	 * @param methodName the name of the Method to use in logging
	 * @param msg the message to log
	 * @return void
	 * @roseuid 3A095EDC009C
	 */
	public final void log(final String className, final String methodName, final String msg) 
	{
		String formattedMsg = formatMsg(className, methodName, msg);
		try {
			TextMessage tMsg = jmsSession.createTextMessage();
			tMsg.setText(formattedMsg);
			logPublisher.publish(tMsg);
		}
		catch (Exception e) {
			System.out.println("LOG ERROR: " + e.getMessage());
			e.printStackTrace();
		}
	}
	
	/**
	 * @roseuid 3A48F47E037A
	 */
	public LogManager() 
	{
		try {
			Context ctx = new InitialContext();
			TopicConnectionFactory qcf = (TopicConnectionFactory)ctx.lookup("TopicConnectionFactory");
			errTopic = (Topic)ctx.lookup("topic/AlkindiErrTopic");
			logTopic = (Topic)ctx.lookup("topic/AlkindiLogTopic");
			
			ctx.close();
			jmsConn = qcf.createTopicConnection();//"sahra", "spot");
			jmsSession = jmsConn.createTopicSession(false, Session.AUTO_ACKNOWLEDGE);
			errPublisher = jmsSession.createPublisher(errTopic);
			logPublisher = jmsSession.createPublisher(logTopic);


		}
		catch(NamingException ne) {
			System.out.println("Naming exception while lookup up JMS resources:" + ne.getMessage());
			ne.printStackTrace();
		}
		catch (JMSException e) {
			System.out.println("Error while initializing JMS resources: " + e.getMessage());
			e.printStackTrace();
		}
		//	Check debug property to set internal debug flag.
		//
		try {
			debug = PropertyManager.getBool("debug");
		}
		catch (Exception e) {
			debug = false;
		}
//		System.out.println("Debug prop = " + PropertyManager.getMWProperty("Alkindi.MW.debug"));
//		System.out.println("Debug is set to " + debug);
	}
}
